
# The bonus macro defines a stat bonus.

$$macro bonus(stat, costPerLevel)
{{
	item "$(stat) Bonus" 
	adj $(stat)+x 
	formula x*$(costPerLevel)
	level 1
	sformat "%0ln Bonus%-10r!$(costPerLevel)/level"
}}


# The benefit macro defines benefits. It's also used for Failings.
# If the benefit is fixed-cost, omit the formula.

$$macro benefit(name, cost, formula, adj, cat, autoitems, req, sformat)
{{
	item "$(name)"
	$$ifdef(formula)
		formula "$(formula)"
		level 1
		format "%0ln%-10rv%-5rc"
		$$ifdef(sformat)
			sformat "%0ln%-10r!$(sformat)"
		$$else
			sformat "%0ln%-10r!$(cost)/level"
		$$endif
		checkexp x>0
	$$else
		cost $(cost)
		format "%0ln%-5rc"
		sformat "%0ln%-5rc"
		editdlg 4
	$$endif
	$$ifdef(adj) adj "$(adj)" $$endif
	$$ifdef(cat) cat "$(cat)" $$endif
	$$ifdef(autoitems)
		# Flag the the automatically items should be deleted
		# along with the main item.
		deleteauto
		autoitems "$(autoitems)" 
	$$endif
	$$ifdef(req) prereq "$(req)" $$endif
}}


# Macro to define the classes. The index is used to
# select the graphic displayed for the class.

$$macro class(name, cost, index)
{{
	item "$(name)"
	adj class=$(index)

	varname level 
	level 1
	formula x*$(cost)
	checkexp x>0 
	format %0ln%-5rv
	sformat "%0ln%-10r!$(cost)/level" 
}}


# Define a common equipment macro that is used by the
# weapon and armor macros.

$$macro equip(name, weight, cost, cat, adj, req)
{{
	item "$(name)"
	cost $(weight)
	editdlg 4 
	$$ifdef(cat) cat "$(cat)" $$endif
	$$ifdef(adj) adj "$(adj)" $$endif
	format %0ln%-14r!^o'Cost'gp%-7rc
	sformat %0ln%-14r!^o'Cost'gp%-7rc 
	$$ifdef(req) prereq "$(req)" $$endif
	opt 
		adj Cost equipcost+x $(cost) 
		end
}}

$$macro armor(name, weight, cost, bonus)
{{
	$$equip($(name), $(weight), $(cost), Armor)
	opt
		adj "Armor Adjustment" armor+x $(bonus)
		end
}}

$$macro shield(name, weight, cost, bonus)
{{
	$$equip($(name), $(weight), $(cost), Shield)
	opt
		adj "Armor Adjustment" armor+x $(bonus)
		end
}}

$$macro weapon(name, weight, cost, dmg, skill, range, strength)
{{
	$$equip($(name), $(weight), $(cost), Weapon)
	$$ifdef(strength) prereq "Main:Strength>=$(strength)" $$endif
	opt
		exp Damage "damage(\"$(dmg)\",dmgbonus(strength)+`Extra Damage`)"
		exp Skill "max(dexterity-2,$$exp("replaceString(skill,'/[^a-zA-Z0-9]/','')"))+`Bonus`" 
		$$ifdef(range) exp Range "$(range)" $$endif
		end
}}



# Three macros are defined for spells. A common spell macro, a mage and a
# priest spell macro. The latter two call the first macro.

$$macro spell(name, stat, range, area, req, cast)
{{
	item "$(name)"
	varname $$exp("replaceString(name, '/[^a-zA-Z0-9]/','')")
	formula skillCost(~x,$(stat))
	checkexp c>0
	level $(stat)-1
	format %0ln%-5rc%-10rv 
	sformat %0ln 
	$$ifdef(req) prereq "$(req)" $$endif
	opt
		$$ifdef(range) exp Range "$(range)" $$endif
		$$ifdef(area) exp "Area of Effect" "$(area)" $$endif
		$$ifdef(cast) text "Casting Time" "$(cast)" $$endif
		end
}}

$$macro mageSpell(name, level, range, area, req, cast)
{{
	$$spell($(name), intelligence, $(range), $(area), , $(cast))
	prereq "Class:Mage$$ifdef(level)>=$(level)$$endif$$ifdef(req);$(req)$$endif"
}}

$$macro priestSpell(name, level, range, area, req, cast)
{{
	$$spell($(name), ego, $(range), $(area), , $(cast))
	prereq "Class:Priest$$ifdef(level)>=$(level)$$endif$$ifdef(req);$(req)$$endif"
}}

$$macro skill(name, stat, class, cat, req)
{{
	item "$(name)"

	# The variable name is formed by deleting all non-alphanumeric 
	# characters from the item name:

	varname $$exp("replaceString(name, '/[^A-Za-z0-9]/', '')")
	level $(stat)
	formula "skillcost(~x,$(stat))"
	checkexp c>=0
	default "$(stat)-2"

	$$ifdef(cat) cat "$(cat)" $$endif
	$$ifdef(class) class "$(class)" $$endif
	$$ifdef(req) prereq "$(req)" $$endif
	format %0ln%-5rc%-10rv%-16ll 
	sformat %0ln%-5ll
}}

